﻿using System;
using System.Collections.Generic;
using System.Windows.Media;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Ink;
using System.Windows.Controls;
using System.Windows;
using static System.Net.Mime.MediaTypeNames;
using System.Drawing;
using System.Xml.Linq;

namespace WpfApp1.Structure
{
    internal class Node : Symbol
    {
        public double area;  //未更新
        public List<Edge> edges_in;
        public List<Edge> edges_out;
        public Node(int id, string text, string category, string color, double[] center, StrokeCollection strokes, List<Symbol> inclusions, Canvas video_text) : base(id, text, category, color, center, strokes, inclusions, video_text)
        {
            this.area = 0;
            this.edges_in = new List<Edge>();
            this.edges_out = new List<Edge>();
        }

        public Node(int id, Canvas video_text) : base(id, video_text)
        {
            this.area = 0;
            this.edges_in = new List<Edge>();
            this.edges_out = new List<Edge>();
        }

        public override string ToString()
        {
            return id.ToString() + ": " + text;
        }

        public override void SetCategory(string category)
        {
            if (this.category == category)
            {
                return;
            }
            this.category = category;
            //仅使用模板笔画
            Node templateNode = SymbolTemplate.d_Templates[category] as Node;
            Matrix matrix = new Matrix();
            double translateX = center[0] - templateNode.center[0];
            double translateY = center[1] - templateNode.center[1];
            matrix.Translate(translateX, translateY);
            //double scale = area / templateNode.area;
            if (strokes.Count > 0)
            {
                Rect oldBounds = strokes.GetBounds();
                Rect templateBounds = templateNode.strokes.GetBounds();
                double scale = Math.Sqrt((oldBounds.Width * oldBounds.Height) / (templateBounds.Width * templateBounds.Height));
                matrix.ScaleAt(scale, scale, center[0], center[1]);
            }
            else
            {
                matrix.ScaleAt(0.5, 0.5, center[0], center[1]);
            }
            strokes.Clear();
            foreach (Stroke stroke in templateNode.strokes.Clone())
            {
                stroke.Transform(matrix, false);
                strokes.Add(stroke);
            }
            RefreshCenter();
            RefreshTextBox();
        }

        public void SetArea(double area)
        {
            double scale = Math.Sqrt(area / this.area);
            Matrix matrix = new Matrix();
            matrix.ScaleAt(scale, scale, center[0], center[1]);
            Resized();
        }

        public override Node Clone()
        {
            Node node = new Node(id, text, category, color, center, strokes, inclusions, text_thumb.Parent as Canvas);
            node.area = area;
            node.text_thumb.Visibility = Visibility.Hidden;
            return node;
        }

        public override void Disconnect()
        {
            foreach (Edge edge in this.edges_in)
            {
                edge.nodes_to.Remove(this);
            }
            foreach (Edge edge in this.edges_out)
            {
                edge.nodes_from.Remove(this);
            }
            foreach (Content content in this.inclusions)
            {
                content.groups.Remove(this);
            }
            //base.Disconnect();
        }
        public override void Connect()
        {
            foreach (Edge edge in this.edges_in)
            {
                edge.nodes_to.Add(this);
            }
            foreach (Edge edge in this.edges_out)
            {
                edge.nodes_from.Add(this);
            }
            foreach (Content content in this.inclusions)
            {
                content.groups.Add(this);
            }
            //base.Connect();
        }
    }
}
